      program fhost
c ---------------------------------------------------------
c Example fortran program illustrating the use of PVM
c ---------------------------------------------------------
      integer i, info, nproc, msgtype, mynum, inst(32)
      integer instance, lth
      double precision result(32), data(100)
      character*12 nodename
      character*8 arch

c ------------ Starting up all the tasks ---------------------------

c     Enroll this program in PVM 
      call fenroll( "fhost", mynum ) 
      if( mynum .lt. 0 ) then
         print *,'failure in fenroll on host'
         stop
      endif

c     Initiate nproc instances of node program 
      print *,'How many node programs (1-32)?'
      read *, nproc
c
c     If arch is set to "*" then ANY configured machine is acceptable
c     otherwise arch should be set to architecture type you wish to use.
      arch  = "pmax_ul4"

      do 10 i=1,nproc 
         call finitiate( "node", arch, inst(i) )
         if( inst(i) .lt. 0 ) then
            print *,'failure in finitiate at instance',i
            stop
         endif
 10   continue

c ------- Begin user program -------- 

      n = 10
c     Initiate data array
      do 20 i=1,n
         data(i) = 1
 20   continue

c     broadcast data to all node programs by using instance= -1 in fsnd
      call finitsend()
      call fputnint( n, 1, info )
      call fputnint( nproc, 1, info )
      call fputndfloat( data, n, info ) 
      msgtype  = 1 
      call fsnd( "node", -1, msgtype, info ) 
  
 
c     wait for results from nodes 
      msgtype  = 2 
      do 30 i=1,nproc 
         call frcv( msgtype, info ) 
         call fgetndfloat( result(i), 1, info )

c        Print result from node
         call frcvinfo( lth, msgtype, nodename, instance, info)
         print *,'result from node ',instance,' is ',result(i)
 30   continue 

 
c --------- End user program -------- 

c     program finished leave PVM before exiting 
      call fleave() 
      stop
      end
